SET TERM ON

PRO Executing cma_collector
PRO Please wait ...

@@cma_set_start.sql

DEF CMA_EXPORTER_VERSION = '1.1'

DEF CMA_DATE_FORMAT = 'YYYY-MM-DD"T"HH24:MI:SS'

ALTER SESSION SET NLS_NUMERIC_CHARACTERS = ".,";
ALTER SESSION SET NLS_SORT = 'BINARY';
ALTER SESSION SET NLS_COMP = 'BINARY';
ALTER SESSION SET NLS_DATE_FORMAT = '&&CMA_DATE_FORMAT.';
ALTER SESSION SET NLS_TIMESTAMP_FORMAT = '&&CMA_DATE_FORMAT.';

-- get host name (up to 30, stop before first '.', no special characters)
COL cma_host_name_short NEW_V cma_host_name_short FOR A30 NOPRI
SELECT LOWER(SUBSTR(SYS_CONTEXT('USERENV', 'SERVER_HOST'), 1, 30)) cma_host_name_short FROM DUAL;
SELECT SUBSTR('&&cma_host_name_short.', 1, INSTR('&&cma_host_name_short..', '.') - 1) cma_host_name_short FROM DUAL;
SELECT TRANSLATE('&&cma_host_name_short.',
'abcdefghijklmnopqrstuvwxyz0123456789-_ ''`~!@#$%&*()=+[]{}\|;:",.<>/?'||CHR(0)||CHR(9)||CHR(10)||CHR(13)||CHR(38),
'abcdefghijklmnopqrstuvwxyz0123456789-_') cma_host_name_short FROM DUAL;
COL cma_host_name_short clear

-- get database name (up to 10, stop before first '.', no special characters)
COL cma_dbname_short NEW_V cma_dbname_short FOR A10 NOPRI
SELECT LOWER(SUBSTR(SYS_CONTEXT('USERENV', 'DB_NAME'), 1, 10)) cma_dbname_short FROM DUAL;
SELECT SUBSTR('&&cma_dbname_short.', 1, INSTR('&&cma_dbname_short..', '.') - 1) cma_dbname_short FROM DUAL;
SELECT TRANSLATE('&&cma_dbname_short.',
'abcdefghijklmnopqrstuvwxyz0123456789-_ ''`~!@#$%&*()=+[]{}\|;:",.<>/?'||CHR(0)||CHR(9)||CHR(10)||CHR(13)||CHR(38),
'abcdefghijklmnopqrstuvwxyz0123456789-_') cma_dbname_short FROM DUAL;
COL cma_dbname_short clear

-- get collection date
COL cma_collection_yyyymmdd_hhmi NEW_V cma_collection_yyyymmdd_hhmi FOR A13 NOPRI
SELECT TO_CHAR(SYSDATE, 'YYYYMMDD_HH24MI') cma_collection_yyyymmdd_hhmi FROM DUAL;
COL cma_collection_yyyymmdd_hhmi clear

COL cma_collection_yyyymmdd NEW_V cma_collection_yyyymmdd FOR A8 NOPRI
SELECT TO_CHAR(SYSDATE, 'YYYYMMDD') cma_collection_yyyymmdd FROM DUAL;
COL cma_collection_yyyymmdd clear

---------------------------------------------------------------------------------------

-- Hardcoded internal schemas list for DBs lower than 12c.

-- max variable length = 240 characters
define _ora_schema1="-
'ADB_ADVISOR'-
,'ANONYMOUS'-
,'APPQOSSYS'-
,'AUDSYS'-
,'BI_SALES'-
,'CTXSYS'-
"

define _ora_schema2="-
,'DBSFWUSER'-
,'DBSNMP'-
,'DIP'-
,'DMSYS'-
,'DVF'-
,'DVSYS'-
,'EXFSYS'-
,'FLOWS_FILES'-
,'FLOWS_040100'-
,'FBDIEBUR_MASTER'-
,'GGSYS'-
,'GRAPH$METADATA'-
,'GRAPH$PROXY_USER'-
,'GSMADMIN_INTERNAL'-
,'GSMCATUSER'-
,'GSMUSER'-
,'LBACSYS'-
"

define _ora_schema3="-
,'MDDATA'-
,'MGDSYS'-
,'MDSYS'-
,'MGMT_VIEW'-
,'OML$MODELS'-
,'OML$PROXY'-
,'OMLMOD$PROXY'-
,'ODIXMLSCHEMA'-
,'ODI_DEMO'-
,'ODI_OGG_REPO'-
,'ODI_STAGING'-
,'ODI_TMP'-
,'OJVMSYS'-
,'OLAPSYS'-
,'ORACLE_OCM'-
,'ORDDATA'-
"

define _ora_schema4="-
,'ORDPLUGINS'-
,'ORDSYS'-
,'ORDS_METADATA'-
,'ORDS_PLSQL_GATEWAY'-
,'ORDS_PUBLIC_USER'-
,'OUTLN'-
,'OWBSYS'-
,'PYQSYS'-
,'REMOTE_SCHEDULER_AGENT'-
,'RMAN$CATALOG'-
,'SH'-
,'SI_INFORMTN_SCHEMA'-
,'SPATIAL_CSW_ADMIN_USR'-
"

define _ora_schema5="-
,'SPATIAL_WFS_ADMIN_USR'-
,'SSB'-
,'SYS'-
,'SYS$UMF'-
,'SYSBACKUP'-
,'SYSDG'-
,'SYSKM'-
,'SYSMAN'-
,'SYSRAC'-
,'SYSTEM'-
,'TSMSYS'-
,'WMSYS'-
,'XDB'-
,'XS$NULL'-
,'XWEEK'-
"

define _ora_schema6="-
,'APEX_030200'-
,'APEX_040000'-
,'APEX_040200'-
,'APEX_050000'-
,'APEX_050100'-
,'APEX_180100'-
,'APEX_210100'-
,'APEX_220100'-
,'APEX_220200'-
,'APEX_INSTANCE_ADMIN_USER'-
,'APEX_LISTENER'-
,'APEX_PUBLIC_USER'-
,'APEX_REST_PUBLIC_USER'-
"

---------------------------------------------------------------------------------------

-- Create skip variable for some versions to avoid code error.

COL run_ver_ge_12 new_v run_ver_ge_12 nopri
COL run_ver_le_11 new_v run_ver_le_11 nopri

select case when version <= 11 then '' else '--' end run_ver_le_11,
       case when version >= 12 then '' else '--' end run_ver_ge_12
from  (select to_number(substr(version,1,instr(version,'.')-1)) version from v$instance);

COL cma_con_id new_v cma_con_id nopri
select
&&run_ver_ge_12. SYS_CONTEXT('USERENV','CON_ID') cma_con_id
&&run_ver_le_11. to_char(0) cma_con_id
from dual;
COL cma_con_id new_v clear

COL run_ver_ne_12101 new_v run_ver_ne_12101 nopri
COL run_ver_eq_12101 new_v run_ver_eq_12101 nopri

select case when version = '12.1.0.1.0' then '--' else '' end run_ver_ne_12101,
       case when version = '12.1.0.1.0' then '' else '--' end run_ver_eq_12101
from v$instance;

---------------------------------------------------------------------------------------

COL dba_cdb new_v dba_cdb nopri
COL run_if_dba new_v run_if_dba nopri
COL run_if_cdb new_v run_if_cdb nopri
select
&&run_ver_ge_12. decode(&&cma_con_id.,0,'dba','cdb') dba_cdb,
&&run_ver_ge_12. decode(&&cma_con_id.,0,'','--') run_if_dba,
&&run_ver_ge_12. decode(&&cma_con_id.,0,'--','') run_if_cdb
&&run_ver_le_11. 'dba' dba_cdb,
&&run_ver_le_11. ''    run_if_dba,
&&run_ver_le_11. '--'  run_if_cdb
from dual;
COL dba_cdb new_v clear
COL run_if_dba new_v clear
COL run_if_cdb new_v clear

---------------------------------------------------------------------------------------

DEF

---------------------------------------------------------------------------------------

SPO cma_&&cma_host_name_short._&&cma_dbname_short._&&cma_collection_yyyymmdd_hhmi..csv

COL cma_metric_group  FOR A15
COL cma_metric_item   FOR A16
COL cma_container_id  FOR A9
COL cma_identifier    FOR A30
COL cma_value         FOR A128

-- header
SELECT 'METGROUP'       cma_metric_group,
       'METITEM'        cma_metric_item,
       'CONTAINER'      cma_container_id,
       'ID'             cma_identifier,
       'VALUE'          cma_value
  FROM DUAL
/

-- collection start
SELECT 'BEGIN'  cma_metric_group,
       'DATE'   cma_metric_item,
       NULL     cma_container_id,
       NULL     cma_identifier,
       SYSDATE  cma_value
  FROM DUAL
/

-- collection user
SELECT 'COLLECT' cma_metric_group,
       'USER'    cma_metric_item,
       NULL      cma_container_id,
       NULL      cma_identifier,
       USER      cma_value
  FROM v$instance
/

-- collection version
SELECT 'COLLECT'                  cma_metric_group,
       'VERSION'                  cma_metric_item,
       NULL                       cma_container_id,
       NULL                       cma_identifier,
       '&&CMA_EXPORTER_VERSION.'  cma_value
  FROM v$instance
/

---------------------------------------------------------------------------------------

-- database dbid
SELECT 'DATABASE'    cma_metric_group,
       'DBID'        cma_metric_item,
       NULL          cma_container_id,
       NULL          cma_identifier,
       TO_CHAR(dbid) cma_value
  FROM v$database
/

-- database name
SELECT 'DATABASE'       cma_metric_group,
       'NAME'           cma_metric_item,
       NULL             cma_container_id,
       NULL             cma_identifier,
       name             cma_value
  FROM v$database
/

-- database created
SELECT 'DATABASE'       cma_metric_group,
       'CREATED'        cma_metric_item,
       NULL             cma_container_id,
       NULL             cma_identifier,
       TO_CHAR(created) cma_value
  FROM v$database
/

-- database db_unique_name
SELECT 'DATABASE'       cma_metric_group,
       'DB_UNIQUE_NAME' cma_metric_item,
       NULL             cma_container_id,
       NULL             cma_identifier,
       db_unique_name   cma_value
  FROM v$database
/

-- database version
SELECT 'DATABASE' cma_metric_group,
       'VERSION'  cma_metric_item,
       NULL       cma_container_id,
       NULL       cma_identifier,
       version    cma_value
  FROM v$instance
/

-- database platform_name
SELECT 'DATABASE'    cma_metric_group,
       'PLATFORM'    cma_metric_item,
       NULL          cma_container_id,
       NULL          cma_identifier,
       platform_name cma_value
  FROM v$database
/

-- database platform_name
SELECT 'DATABASE'    cma_metric_group,
       'MULTITENANT' cma_metric_item,
       NULL          cma_container_id,
       NULL          cma_identifier,
       decode(&&cma_con_id.,0,'FALSE','TRUE') cma_value
  FROM dual
/

---------------------------------------------------------------------------------------

-- instance instance_name
SELECT 'INSTANCE'                 cma_metric_group,
       'NAME'                     cma_metric_item,
       NULL                       cma_container_id,
       TO_CHAR(h.instance_number) cma_identifier,
       h.instance_name            cma_value
  FROM gv$instance h
 ORDER BY
       h.instance_number
/

-- instance instance_started
SELECT 'INSTANCE'                 cma_metric_group,
       'STARTED'                  cma_metric_item,
       NULL                       cma_container_id,
       TO_CHAR(h.instance_number) cma_identifier,
       h.startup_time             cma_value
  FROM gv$instance h
 ORDER BY
       h.instance_number
/

-- instance host_name
SELECT 'INSTANCE'                 cma_metric_group,
       'HOST_NAME'                cma_metric_item,
       NULL                       cma_container_id,
       TO_CHAR(h.instance_number) cma_identifier,
       h.host_name                cma_value
  FROM gv$instance h
 ORDER BY
       h.instance_number
/

---------------------------------------------------------------------------------------

-- containers_name - cdb
SELECT 'PDB'             cma_metric_group
       ,'NAME'           cma_metric_item
       ,NULL             cma_container_id
&&run_ver_ge_12.      ,to_char(con_id)  cma_identifier
&&run_ver_ge_12.      ,name             cma_value
&&run_ver_ge_12.   FROM v$containers
&&run_ver_le_11.   FROM dual
WHERE  &&cma_con_id.!=0
/

---------------------------------------------------------------------------------------

-- storage size - non-cdb
SELECT 'STORAGE'                  cma_metric_group,
       'SIZE'                     cma_metric_item,
       NULL                       cma_container_id,
       NULL                       cma_identifier,
       to_char(sum(h.bytes))      cma_value
  FROM v$datafile h
WHERE  &&cma_con_id.=0
HAVING count(*)>0
/

-- storage size - cdb
SELECT 'STORAGE'                  cma_metric_group,
       'SIZE'                     cma_metric_item,
&&run_ver_ge_12.       to_char(con_id)            cma_container_id,
       NULL                       cma_identifier,
       to_char(sum(h.bytes))      cma_value
  FROM v$datafile h
WHERE  &&cma_con_id.!=0
HAVING count(*)>0
&&run_ver_ge_12. group by to_char(con_id)
/

---------------------------------------------------------------------------------------

-- database db_block_size - non-cdb
SELECT 'DATABASE'           cma_metric_group,
       'DB_BLOCK_SIZE'      cma_metric_item,
       NULL                 cma_container_id,
       NULL                 cma_identifier,
       SUBSTR(value, 1, 10) cma_value
  FROM v$system_parameter2
 WHERE name = 'db_block_size'
   AND &&cma_con_id.=0
/

-- database db_block_size - cdb
SELECT 'DATABASE'           cma_metric_group,
       'DB_BLOCK_SIZE'      cma_metric_item,
&&run_ver_ge_12.       to_char(con_id)      cma_container_id,
       NULL                 cma_identifier,
       SUBSTR(value, 1, 10) cma_value
  FROM v$system_parameter2
 WHERE name = 'db_block_size'
   AND &&cma_con_id.!=0
/

---------------------------------------------------------------------------------------

-- database charset - non-cdb
SELECT 'DATABASE'                                          cma_metric_group,
       decode(PARAMETER,'NLS_CHARACTERSET','CHARSET','NCHARSET') cma_metric_item,
       NULL                                                cma_container_id,
       NULL                                                cma_identifier,
       value                                               cma_value
  FROM nls_database_parameters
 WHERE parameter in ('NLS_NCHAR_CHARACTERSET','NLS_CHARACTERSET')
   AND &&cma_con_id.=0
/

-- database charset - cdb
SELECT 'DATABASE'                                            cma_metric_group,
       decode(PARAMETER,'NLS_CHARACTERSET','CHARSET','NCHARSET') cma_metric_item,
&&run_ver_ge_12. to_char(con_id)                           cma_container_id,
       NULL                                                  cma_identifier,
       value                                               cma_value
&&run_ver_ge_12.&&run_ver_ne_12101. FROM containers(nls_database_parameters) -- containers clause started with 12.1.0.2.0
&&run_ver_eq_12101. FROM cdb$view(nls_database_parameters)
&&run_ver_le_11. FROM nls_database_parameters
WHERE parameter in ('NLS_NCHAR_CHARACTERSET','NLS_CHARACTERSET')
AND &&cma_con_id.!=0
/

---------------------------------------------------------------------------------------
-- archive log volume for last 21 days

SELECT 'LOGVOL'           cma_metric_group,
        'SIZE_GIB_DAY'    cma_metric_item,
        NULL              cma_container_id,
        to_char(completion_time, 'yyyymmdd') cma_identifier,
        to_char(ceil(sum(BLOCKS*BLOCK_SIZE)/power(1024,3))) cma_value
  from V$ARCHIVED_LOG
  where dest_id = (select dest_id from V$ARCHIVE_DEST_STATUS where status='VALID' and type='LOCAL' and rownum = 1)
    and trunc(COMPLETION_TIME) > sysdate - 21
   group by to_char(completion_time, 'yyyymmdd')
  order by 1,3
/

---------------------------------------------------------------------------------------

SET TERM OFF
SPO OFF

col run_if_obj_exists new_v run_if_obj_exists nopri
col run_if_obj_missing new_v run_if_obj_missing nopri
select decode(count(*),0,'--','') run_if_obj_exists,
       decode(count(*),0,'','--') run_if_obj_missing
from   all_views
where  view_name='DBA_GOLDENGATE_SUPPORT_MODE'
and    owner='SYS';
col run_if_obj_exists clear
col run_if_obj_missing clear

SET TERM ON
SPO cma_&&cma_host_name_short._&&cma_dbname_short._&&cma_collection_yyyymmdd_hhmi..csv APP

---------------------------------------------------------------------------------------

-- OGG Extract restriction Support Mode None
select 'GOLDENGATE'      cma_metric_group,
       'EXTRACT'         cma_metric_item,
&&run_if_obj_missing.    0
&&run_if_obj_missing. from dual
&&run_if_obj_missing. where 1=2
&&run_if_obj_exists.&&run_ver_le_11.      to_char(0)        cma_container_id,
&&run_if_obj_exists.&&run_ver_ge_12.      to_char(con_id)   cma_container_id,
&&run_if_obj_exists.      NULL              cma_identifier,
&&run_if_obj_exists.      to_char(count(1)) cma_value
&&run_if_obj_exists.&&run_ver_le_11.   from dba_goldengate_support_mode
&&run_if_obj_exists.&&run_ver_ge_12.   from cdb_goldengate_support_mode
&&run_if_obj_exists.&&run_ver_le_11.   where owner not in ( &&_ora_schema1 &&_ora_schema2 &&_ora_schema3 &&_ora_schema4 &&_ora_schema5 &&_ora_schema6 )
&&run_if_obj_exists.&&run_ver_ge_12.   where owner in (select username from cdb_users where oracle_maintained = 'N')
&&run_if_obj_exists.   and support_mode = 'NONE'
&&run_if_obj_exists.&&run_ver_ge_12.   group by con_id
&&run_if_obj_exists.   order by 1,2
/

---------------------------------------------------------------------------------------
-- Size in GiB of tables with unsupported datatypes

-- select added because of the define variables cant start a statement.
select * from (
&&run_if_cdb. select 'GOLDENGATE'        cma_metric_group,
&&run_if_cdb.        'UNSUPPORTED_TYPE'  cma_metric_item,
&&run_if_cdb.         to_char(s.con_id)  cma_container_id,
&&run_if_cdb.         to_char(u.user_id) cma_identifier,
&&run_if_cdb.         to_char(ceil(sum(bytes)/power(1024,3))) cma_value
&&run_if_cdb.   from cdb_segments s
&&run_if_cdb.   join cdb_tables t on s.owner=t.owner and s.segment_name=t.table_name and segment_type like 'TABLE%'
&&run_if_cdb.   and s.con_id=t.con_id
&&run_if_cdb.   join cdb_users u on  s.owner=u.username
&&run_if_cdb.   and s.con_id=u.con_id
&&run_if_cdb.   where u.oracle_maintained = 'N'
&&run_if_cdb.     and exists
&&run_if_cdb.     (
&&run_if_cdb.       select 1
&&run_if_cdb.       from   cdb_tab_columns c
&&run_if_cdb.       where (c.data_type in ('ORDDICOM', 'BFILE', 'TIMEZONE_REGION', 'BINARY_INTEGER', 'PLS_INTEGER', 'UROWID',
&&run_if_cdb.               'URITYPE', 'MLSLABEL', 'TIMEZONE_ABBR', 'ANYDATA', 'ANYDATASET', 'ANYTYPE')
&&run_if_cdb.               or c.data_type like 'INTERVAL%')
&&run_if_cdb.           and c.table_name not like 'BIN$%'
&&run_if_cdb.           and s.owner = c.owner and t.table_name= c.table_name
&&run_if_cdb.           and s.con_id=c.con_id
&&run_if_cdb.     )
&&run_if_cdb. group by s.con_id, u.user_id
&&run_if_cdb. having count(*) > 0
&&run_if_cdb. order by 1
-------------------------------------------
&&run_if_dba. select 'GOLDENGATE'        cma_metric_group,
&&run_if_dba.        'UNSUPPORTED_TYPE'  cma_metric_item,
&&run_if_dba.         to_char(0)         cma_container_id,
&&run_if_dba.         to_char(u.user_id) cma_identifier,
&&run_if_dba.         to_char(ceil(sum(bytes)/power(1024,3))) cma_value
&&run_if_dba.   from dba_segments s
&&run_if_dba.   join dba_tables t on s.owner=t.owner and s.segment_name=t.table_name and segment_type like 'TABLE%'
&&run_if_dba.   join dba_users u on  s.owner=u.username
&&run_if_dba. &&run_ver_le_11.   where s.owner not in ( &&_ora_schema1 &&_ora_schema2 &&_ora_schema3 &&_ora_schema4 &&_ora_schema5 &&_ora_schema6 )
&&run_if_dba. &&run_ver_ge_12.   where u.oracle_maintained = 'N'
&&run_if_dba.     and exists
&&run_if_dba.     (
&&run_if_dba.       select 1
&&run_if_dba.       from   dba_tab_columns c
&&run_if_dba.       where (c.data_type in ('ORDDICOM', 'BFILE', 'TIMEZONE_REGION', 'BINARY_INTEGER', 'PLS_INTEGER', 'UROWID',
&&run_if_dba.               'URITYPE', 'MLSLABEL', 'TIMEZONE_ABBR', 'ANYDATA', 'ANYDATASET', 'ANYTYPE')
&&run_if_dba.               or c.data_type like 'INTERVAL%')
&&run_if_dba.           and c.table_name not like 'BIN$%'
&&run_if_dba.           and s.owner = c.owner and t.table_name= c.table_name
&&run_if_dba.     )
&&run_if_dba. group by u.user_id
&&run_if_dba. having count(*) > 0
&&run_if_dba. order by 1
-------------------------------------------
)
/

---------------------------------------------------------------------------------------
-- Data efficiency for DBA Views

select * from (
-------------------------------------------
&&run_if_dba. with db_size_gb as (
&&run_if_dba.   select sum(bytes) as total_size_bytes
&&run_if_dba.   from   dba_data_files
&&run_if_dba. ),
&&run_if_dba. alloc_space as (
&&run_if_dba.   select decode((sum(bytes)),0,null,sum(bytes)) as user_space_bytes
&&run_if_dba.   from   dba_segments s
&&run_if_dba.   join   dba_tables t on s.owner=t.owner and s.segment_name=t.table_name
&&run_if_dba.   join   dba_tablespaces v on s.tablespace_name = v.tablespace_name
&&run_if_dba.   where  s.TABLESPACE_NAME not in ('SYSTEM','SYSAUX')
&&run_if_dba.   and    v.contents = 'PERMANENT'
&&run_if_dba.   and    s.segment_type like '%TABLE%'
&&run_if_dba.   and    t.table_name not like 'BIN$%'
&&run_if_dba. )
&&run_if_dba. select 'DATABASE'        cma_metric_group,
&&run_if_dba.        'DATA_EFFICIENCY' cma_metric_item,
&&run_if_dba.        to_char(0) as cma_container_id,
&&run_if_dba.        NULL as cma_identifier,
&&run_if_dba.        to_char(ceil(user_space_bytes/total_size_bytes*100)) yama_value
&&run_if_dba. from db_size_gb, alloc_space
-------------------------------------------
&&run_if_cdb. with db_size_gb as (
&&run_if_cdb.   select sum(bytes) as total_size_bytes, con_id
&&run_if_cdb.   from   cdb_data_files
&&run_if_cdb.   group by con_id
&&run_if_cdb. ),
&&run_if_cdb. alloc_space as (
&&run_if_cdb.   select decode((sum(bytes)),0,null,sum(bytes)) as user_space_bytes, s.con_id
&&run_if_cdb.   from   cdb_segments s
&&run_if_cdb.   join   cdb_tables t on s.owner=t.owner and s.segment_name=t.table_name and s.con_id=t.con_id
&&run_if_cdb.   join   cdb_tablespaces v on s.tablespace_name = v.tablespace_name and s.con_id=v.con_id
&&run_if_cdb.   where  s.TABLESPACE_NAME not in ('SYSTEM','SYSAUX')
&&run_if_cdb.   and    v.contents = 'PERMANENT'
&&run_if_cdb.   and    s.segment_type like '%TABLE%'
&&run_if_cdb.   and    t.table_name not like 'BIN$%'
&&run_if_cdb.   group by s.con_id
&&run_if_cdb. )
&&run_if_cdb. select 'DATABASE'        cma_metric_group,
&&run_if_cdb.        'DATA_EFFICIENCY' cma_metric_item,
&&run_if_cdb.        to_char(db_size_gb.con_id) as cma_container_id,
&&run_if_cdb.        NULL as cma_identifier,
&&run_if_cdb.        to_char(ceil(user_space_bytes/total_size_bytes*100)) yama_value
&&run_if_cdb. from   db_size_gb, alloc_space
&&run_if_cdb. where  db_size_gb.con_id = alloc_space.con_id
-------------------------------------------
)
/
---------------------------------------------------------------------------------------
-- Tablespace size in GIB

select * from (
&&run_if_cdb. select 'TBS'               cma_metric_group,
&&run_if_cdb.        'SIZE_GIB'          cma_metric_item,
&&run_if_cdb.         to_char(t.con_id)  cma_container_id,
&&run_if_cdb.         to_char(t.ts#)     cma_identifier,
&&run_if_cdb.         to_char(ceil(sum(nvl(s.bytes,0))/power(1024,3))) cma_value
&&run_if_cdb. from v$tablespace t
&&run_if_cdb. left join cdb_segments s on t.name=s.tablespace_name and t.con_id=s.con_id
&&run_if_cdb. group by t.con_id, t.ts#
&&run_if_cdb. order by 3, 4
-------------------------------------------
&&run_if_dba. select 'TBS'              cma_metric_group,
&&run_if_dba.        'SIZE_GIB'         cma_metric_item,
&&run_if_dba.        to_char(0)         cma_container_id,
&&run_if_dba.        to_char(t.ts#)     cma_identifier,
&&run_if_dba.        to_char(ceil(sum(nvl(s.bytes,0))/power(1024,3))) cma_value
&&run_if_dba. from v$tablespace t left join dba_segments s on t.name=s.tablespace_name
&&run_if_dba. group by t.ts#
&&run_if_dba. order by 4
-------------------------------------------
)
/

---------------------------------------------------------------------------------------
-- Size of user segments with at least 1 GIB

select * from (
&&run_if_cdb. select 'USER_SEGMENTS'     cma_metric_group,
&&run_if_cdb.        'SIZE_GIB'          cma_metric_item,
&&run_if_cdb.         to_char(s.con_id)  cma_container_id,
&&run_if_cdb.         to_char(u.user_id) cma_identifier,
&&run_if_cdb.         s.segment_type || ':' || to_char(ceil(sum(bytes)/power(1024,3))) cma_value
&&run_if_cdb. from cdb_segments s
&&run_if_cdb. join cdb_users u on s.owner=u.username and s.con_id=u.con_id
&&run_if_cdb. where u.oracle_maintained='N'
&&run_if_cdb. and   s.segment_name not like 'BIN$%'
&&run_if_cdb. group by s.con_id, u.user_id, s.segment_type
&&run_if_cdb. having sum(bytes)/power(1024,1) > 1 -- At least 1 GBytes
&&run_if_cdb. order by 3,4
-------------------------------------------
&&run_if_dba. select 'USER_SEGMENTS'  cma_metric_group,
&&run_if_dba.        'SIZE_GIB'         cma_metric_item,
&&run_if_dba.        to_char(0)         cma_container_id,
&&run_if_dba.        to_char(u.user_id) cma_identifier,
&&run_if_dba.        s.segment_type || ':' || to_char(ceil(sum(bytes)/power(1024,3))) cma_value
&&run_if_dba. from dba_segments s
&&run_if_dba. join dba_users u on s.owner=u.username
&&run_if_dba. &&run_ver_le_11.   where s.owner not in ( &&_ora_schema1 &&_ora_schema2 &&_ora_schema3 &&_ora_schema4 &&_ora_schema5 &&_ora_schema6 )
&&run_if_dba. &&run_ver_ge_12.   where u.oracle_maintained = 'N'
&&run_if_dba. and s.segment_name not like 'BIN$%'
&&run_if_dba. group by u.user_id, s.segment_type
&&run_if_dba. having sum(bytes)/power(1024,1) > 1 -- At least 1 GBytes
&&run_if_dba. order by 4
-------------------------------------------
)
/

---------------------------------------------------------------------------------------

-- collection end
SELECT 'END'                      cma_metric_group,
       'DATE'                     cma_metric_item,
       NULL                       cma_container_id,
       NULL                       cma_identifier,
       SYSDATE                    cma_value
  FROM DUAL
/

SPO OFF

@@cma_set_end.sql

---------------------------------------------------------------------------------------

PRO
PRO Generated cma_&&cma_host_name_short._&&cma_dbname_short._&&cma_collection_yyyymmdd_hhmi..csv
PRO

HOS zip -qmj cma_output_&&cma_host_name_short._&&cma_collection_yyyymmdd..zip cma_&&cma_host_name_short._&&cma_dbname_short._&&cma_collection_yyyymmdd._*.csv

PRO
PRO Generated cma_output_&&cma_host_name_short._&&cma_collection_yyyymmdd..zip
PRO
